//								EJEMPLO 3
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
// Programa combinacional. Segn el estado de los interruptores RA0 y RA1, activar
// los leds RB0-RB7 conectados a la puerta B, conforme a la siguiente tabla de
// la verdad:
//
// RA1 RA0  RB7 RB6 RB5 RB4 RB3 RB2 RB1 RB0
// --- ---  --- --- --- --- --- --- --- ---
//  0   0    1   0   1   0   1   0   1   0
//  0   1    0   1   0   1   0   1   0   1
//  1   0    0   0   0   0   1   1   1   1
//  1   1    1   1   1   1   0   0   0   0

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)

main()
{
  	output_b(0x0);					//Borra las salidas
	setup_adc_ports(NO_ANALOGS);	//Puerta A digital
  	set_tris_a(0x3F);				//Puerta A entrada
  	set_tris_b(0x00);				//Puerta B salida

	  while(1)
 	   	switch(input_a() & 0b00000011)// Mascara para RA0 y RA1
    	{
      		case 0: output_b(0b10101010); break;
      		case 1: output_b(0b01010101); break;
      		case 2: output_b(0b00001111); break;
      		case 3: output_b(0b11110000); break;
			default:;
    	}
}

